#pragma once

#include <boost/asio/spawn.hpp>

namespace coro {


inline boost::asio::io_context& getIoContext(const boost::asio::yield_context& yield) {
    decltype(auto) executor = boost::asio::get_associated_executor(yield.handler_);
    if (auto target = executor.target<boost::asio::strand<boost::asio::io_context::executor_type>>()) {
        return target->get_inner_executor().context();
    }
    if (auto target = executor.target<boost::asio::io_context::strand>()) {
        return target->context();
    }
    if (auto target = executor.target<boost::asio::io_context::executor_type>()) {
        return target->context();
    }
    throw std::invalid_argument("Can't obtain io_context from yield");
};

}
