import requests
from library.python.vault_client.instances import Production as VaultClient
from library.python.vault_client.errors import ClientError


def get_oauth_from_yav():
    secret_id = 'sec-01d34s477p8fak79sq374swfqa'

    client = VaultClient(decode_files=True)
    try:
        secret = client.get_version(secret_id)
    except ClientError as e:
        print('Failed to get secret from yav: %s', e)
        raise

    return secret['value']['juggler.oauth.token'], secret['value']['abc.oauth.token']


def regenerate_dashboard(token, dashboard):
    headers = {'Authorization': 'OAuth {}'.format(token)}

    resp = requests.post('https://juggler-api.search.yandex.net/v2/dashboards/get_dashboards',
                         headers=headers, json={'filters': [{'address': dashboard['address']}]})
    if resp.status_code != requests.codes.ok:
        return resp
    items = resp.json()['items']
    if len(items) > 1:
        raise RuntimeError('More than 1 {} dashboard found'.format(dashboard['address']))

    if len(items) > 0:
        resp = requests.post('https://juggler-api.search.yandex.net/v2/dashboards/remove_dashboard',
                             headers=headers, json={'dashboard_id': items[0]['dashboard_id']})
        if resp.status_code != requests.codes.ok:
            return resp

    resp = requests.post('https://juggler-api.search.yandex.net/v2/dashboards/set_dashboard',
                         headers=headers, json=dashboard)
    return resp


def get_owners(token):
    owners = []
    headers = {'Authorization': 'OAuth {}'.format(token)}
    resp = requests.get('https://abc-back.yandex-team.ru/api/v4/services/30889/on_duty/', headers=headers)
    for shift in resp.json():
        if shift['schedule']['slug'] == 'primary':
            owners = sorted([o['person']['login'] for o in shift['schedule']['orders']])
    owners.append('robot-gerrit')
    return owners
