from typing import List
from dataclasses import dataclass


class Hostname:
    @staticmethod
    def full(template):
        name = {
            'prod': 'production',
            'corp': 'intranet-production',
            'test': 'testing',
        }
        return lambda env: template.format(name.get(env, env))

    @staticmethod
    def short(template):
        return lambda env: template.format(env)

    @staticmethod
    def fixed(template):
        return lambda _: template

    @staticmethod
    def any():
        return lambda _: None

    @staticmethod
    def by_dict(host_dict):
        return lambda env: host_dict.get(env, '')


@dataclass
class Alert:
    name: str
    namespaces: List[str]
    hosts: List
    services: List[str]


def merge_alerts(name, alerts):
    new_alert = Alert(name, [], [], [])
    for a in alerts:
        new_alert.namespaces += [n for n in a.namespaces if n not in new_alert.namespaces]
        new_alert.hosts += [n for n in a.hosts if n not in new_alert.hosts]
        new_alert.services += [n for n in a.services if n not in new_alert.services]
    return new_alert


@dataclass
class Escalation:
    name: str
    namespaces: List[str]
    hosts: List
    services: List[str]


@dataclass
class Dashboard:
    name: str
    address: str
    widgets: List
    width: int = None
    limit: int = None


@dataclass
class Environment:
    name: str
    dashboards: List[Dashboard]
