import json
from aiohttp import web

from .duty import get_duty

ALLOWED_QUEUE = 'MAILPGDUTY'


async def set_task(session, tokens, task_id, assignee):
    headers = {'Authorization': 'OAuth {}'.format(tokens['startrek.oauth.token'])}
    payload = {'assignee': assignee}
    await session.patch('https://st-api.yandex-team.ru/v2/issues/{}'.format(task_id),
                        headers=headers, data=json.dumps(payload))


async def assign(session, tokens, req):
    task_id = req.query.get('task_id', '').upper()
    if not task_id.startswith(ALLOWED_QUEUE):
        return web.Response(status=400, text='bad queue {}\n'.format(task_id))

    duty = await get_duty(session, tokens)
    await set_task(session, tokens, task_id, duty.get('primary'))
    return web.Response(text='assigned {} for {}\n'.format(duty.get('primary'), task_id))
