import json
from aiohttp import web


async def get_duty(session, tokens):
    on_duty = {}
    headers = {'Authorization': 'OAuth {}'.format(tokens['abc.oauth.token'])}
    async with session.get('https://abc-back.yandex-team.ru/api/v4/services/30889/on_duty/', headers=headers) as resp:
        res = await resp.json()
        try:
            for shift in res:
                on_duty[shift['schedule']['slug']] = shift['person']['login']
        except KeyError:
            pass
        finally:
            return on_duty


async def on_duty(session, tokens):
    duty = await get_duty(session, tokens)
    return web.Response(text=json.dumps(duty))
