#!/bin/bash

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

GROUPIE_CONFIGS_PATH="/etc/groupie"
mkdir -p ${GROUPIE_CONFIGS_PATH}

ROBOT_GERRIT_SECRET="sec-01d34s477p8fak79sq374swfqa"
ROBOT_GERRIT_TOKENS_PATH="${GROUPIE_CONFIGS_PATH}/robot-gerrit-tokens.json"
# make 10 attemps in case of any problems
for i in {1..10}; do
    echo "getting tokens from yav"
    yav get version ${ROBOT_GERRIT_SECRET} -o > ${ROBOT_GERRIT_TOKENS_PATH}
    if [[ -s ${ROBOT_GERRIT_TOKENS_PATH} ]]; then
        echo "chmod ${ROBOT_GERRIT_TOKENS_PATH}"
        chmod 600 ${ROBOT_GERRIT_TOKENS_PATH}
        if [[ "$?" != 0 ]]; then
            continue
        fi
        echo "ok"
        break
    else
        echo "No ${ROBOT_GERRIT_TOKENS_PATH} found, sleeping"
        sleep 5
    fi
done
if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown ${ATTACHSID_AES_TARGET_PATH}, cannot start"
    exit 1
fi

ln -sf /etc/nginx/sites-available/groupie.conf /etc/nginx/sites-enabled/groupie.conf

rm /etc/supervisor/conf.d/graphite-sender.conf
rm /etc/supervisor/conf.d/juggler-client.conf
