#include <mail/webmail/http_api_helpers/include/error.h>

namespace http_api {

std::string HttpApiCategory::message(int v) const {
    switch(Error(v)) {
        case Error::unexpectedException:
            return "unexpected exception";
        case Error::unknownErrorCategory:
            return "error_code with unknown category";
        case Error::missingParam:
            return "missing expected param";
        case Error::wrongHttpMethod:
            return "wrong http method";
        case Error::invalidArgument:
            return "invalid argument";
    }
    return "unknown enum code";
}

const HttpApiCategory& getHttpApiCategory() {
    static HttpApiCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(Error e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getHttpApiCategory());
}

mail_errors::error_code make_error(Error e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
