#pragma once

#include <mail_errors/error_code.h>
#include <yamail/expected.h>

namespace http_api {

enum class Error {
    unexpectedException = 1,
    unknownErrorCategory,
    invalidArgument,
    missingParam,
    wrongHttpMethod
};

struct HttpApiCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "http_api";
    }

    std::string message(int v) const override;
};

const HttpApiCategory& getHttpApiCategory();

mail_errors::error_code::base_type make_error_code(Error e);
mail_errors::error_code make_error(Error e, std::string what);

inline auto make_unexpected(Error e, std::string what) {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}

namespace boost::system {
template <>
struct is_error_code_enum<http_api::Error> : std::true_type {};
}
