#pragma once

#include <yplatform/ptree.h>
#include <yplatform/find.h>


namespace http_api {

template<class T>
auto findDependency(const yplatform::ptree& cfg, const std::string& path) {
    const std::string name = cfg.get<std::string>(path);
    if (!yplatform::exists<T>(name)) {
        throw std::runtime_error("Cannot find config for module "+name);
    } else {
        return yplatform::find<T, std::shared_ptr>(name);
    }
}

}
