#pragma once

#include <mail/webmail/http_api_helpers/include/result.h>
#include <mail/webmail/http_api_helpers/include/handler_helpers.h>

namespace http_api {

template<class BindInfo>
void bindPingHandler(const BindInfo& info, WrappedFunction<PingResult> fn) {
    bindGET<PingResult>(info, "/ping", fn);
}

template<class BindInfo>
void bindPingHandler(const BindInfo& info) {
    bindPingHandler(info, [=] (ymod_webserver::response_ptr, boost::asio::yield_context) {
        return PingResult::success();
    });
}

}
