#include <mail/webmail/http_api_helpers/include/merge_args_as_tskv.h>
#include <yplatform/tskv/tskv.h>
#include <butil/datetime/date_utils.h>
#include <butil/datetime/timezone.h>
#include <mail/http_getter/client/include/logger.h>


namespace http_api {

std::string mergeArgsAsTskv(const ymod_webserver::http::stream_ptr& req,
                            const std::set<std::string>& paramsToHide,
                            const std::string& tskvFormat) {
    namespace tskv = yplatform::tskv;

    const auto timestamp = std::time(nullptr);
    const auto iter = req->request()->headers.find("x-request-id");

    std::ostringstream stream;
    auto tskvWrapper = stream << tskv::utf;
    tskvWrapper << tskv::attr("tskv_format", tskvFormat)
                << tskv::attr("timestamp", timestamp)
                << tskv::attr("time", DateUtils::tztime2string(timestamp, "Europe/Moscow", "%Y-%m-%dT%H:%M:%S"))
                << tskv::attr("timezone", butil::getTzOffset(timestamp))
                << tskv::attr("x_request_id", iter == req->request()->headers.end() ? std::string() : iter->second);

    for(const auto& pair: req->request()->url.params) {
        if (paramsToHide.contains(pair.first)) {
            tskvWrapper << tskv::attr(pair.first, http_getter::makeHiddenValue(pair.second));
        } else {
            tskvWrapper << tskv::attr(pair.first, pair.second);
        }
    }

    return stream.str();
}

void logArgsAsTskv(const ymod_webserver::http::stream_ptr& req, const LogArgsAsTskvConfig& cfg) {
   YLOG(cfg.argsLogger, info) << mergeArgsAsTskv(req, cfg.paramsToHide, cfg.tskvFormat);
}

}
