#include <mail/webmail/mulcagate_client/mulca_client.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>
#include <yamail/data/deserialization/ptree.h>


BOOST_FUSION_DEFINE_STRUCT((mail_getter)(detail)(reflection), MulcaSettings,
    (std::string, storage_name_space)
    (std::string, service)
    (unsigned, connect_timeout_ms)
    (unsigned, get_timeout_ms)
    (unsigned, put_timeout_ms)
)


namespace mail_getter {

mail_getter::ServiceFactoryPtr initMailStorage(const yplatform::ptree& cfg, const http_getter::TypedModulePtr& httpGetter) {
    using namespace mail_getter::mulcagate;
    using namespace mail_getter;

    auto endpoint = yamail::data::deserialization::fromPtree<http_getter::TypedEndpoint>(cfg.get_child("endpoint"));
    auto httpClient = mail_getter::mulcagate::http::detail::getMulcagateHttpClientAdaptor(httpGetter, endpoint);

    auto internalSettings = yamail::data::deserialization::fromPtree<mail_getter::detail::reflection::MulcaSettings>(cfg);

    auto settings = std::make_shared<mulcagate::Settings>();
    settings->retries = 1;
    settings->connectTimeoutMs = internalSettings.connect_timeout_ms;
    settings->getTimeoutMs = internalSettings.get_timeout_ms;
    settings->putTimeoutMs = internalSettings.put_timeout_ms;

    settings->service = std::move(internalSettings.service);
    settings->storageNameSpace = std::move(internalSettings.storage_name_space);

    return createServiceFactory(std::move(settings), std::move(httpClient));
}

}
