#!/bin/bash

set -ex

case "$ENVIRONMENT" in
    production|prestable|intranet-production|intranet-prestable|corp|corp-prestable)
        ATTACHSID_SECRET_ID=sec-01db2sdc5cdnrjw62k3gr8ckcn
        ATTACHSID_AES_KEY_ID='webmail-production-attachsid-aes-key'
        ATTACHSID_HMAC_KEY_ID='webmail-production-attachsid-hmac-key'
        ;;
    testing|load)
        ATTACHSID_SECRET_ID=sec-01day8mapnzbrqy79jb4bnmghc
        ATTACHSID_AES_KEY_ID='webmail-testing-attachsid-aes-key'
        ATTACHSID_HMAC_KEY_ID='webmail-testing-attachsid-hmac-key'
        ;;
    *)
        echo "Unknown environment type: $ENVIRONMENT, cannot start"
        exit 1
        ;;
esac

ATTACHSID_AES_TARGET_PATH=/app/secrets/attach_sid_aes_keys.json
# make 10 attemps in case of any problems
for i in {1..10}; do
    echo "getting attach_sid_aes_keys.json"
    yav get version ${ATTACHSID_SECRET_ID} -o ${ATTACHSID_AES_KEY_ID} > ${ATTACHSID_AES_TARGET_PATH}

    if [[ -s ${ATTACHSID_AES_TARGET_PATH} ]]; then
        echo "ok"
        break
    else
        echo "No ${ATTACHSID_AES_TARGET_PATH} found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown ${ATTACHSID_AES_TARGET_PATH}, cannot start"
    exit 1
fi

ATTACHSID_HMAC_TARGET_PATH=/app/secrets/attach_sid_hmac_keys.json
# make 10 attemps in case of any problems
for i in {1..10}; do
    echo "getting attach_sid_hmac_keys.json"
    yav get version ${ATTACHSID_SECRET_ID} -o ${ATTACHSID_HMAC_KEY_ID} > ${ATTACHSID_HMAC_TARGET_PATH}

    if [[ -s ${ATTACHSID_HMAC_TARGET_PATH} ]]; then
        echo "ok"
        break
    else
        echo "No ${ATTACHSID_HMAC_TARGET_PATH} found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown ${ATTACHSID_HMAC_TARGET_PATH}, cannot start"
    exit 1
fi