#!/bin/bash

set -ex

for i in {1..10}; do
    if [[ -f /app/resources/tzdata/tzdata.tar.gz ]]; then
        echo "extracting tzdata and geodata5.bin"

        mkdir -p /var/cache/geobase/tzdata/
        tar -xvzf /app/resources/tzdata/tzdata.tar.gz -C /var/cache/geobase/tzdata/
        ln -sf /var/cache/geobase/tzdata /usr/share/geobase
        ln -sf /app/resources/geobase/geodata5.bin /var/cache/geobase/geodata5.bin

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No tzdata found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to extract tzdata and geodata5.bin, cannot start"
    exit 1
fi
