#!/bin/bash

set -ex

for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/
        rm -rf /var/log
        ln -sf /ephemeral/var/log /var/log
        chown -R wmi:wmi /var/log/$dog_name

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi
