#!/bin/bash

set -ex

for i in {1..10}; do
    if [[ -f /secrets/.pgpass ]]; then
        echo "copying pgpass"
        cp -f /secrets/.pgpass /home/wmi/.pgpass

        echo "chowning pgpass"
        chown wmi:wmi /home/wmi/.pgpass

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No pgpass found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown pgpass, cannot start"
    exit 1
fi

for i in {1..10}; do
    if [[ -f /secrets/root.crt ]]; then
        echo "copying root.crt"
        cp -f /secrets/root.crt /home/wmi/.postgresql/root.crt

        echo "chowning root.crt"
        chown wmi:wmi /home/wmi/.postgresql/root.crt

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No root.crt found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown root.crt, cannot start"
    exit 1
fi
