#!/bin/bash

set -ex

for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        LOGS="push-client-main push-client-historydb $*"
        for LOG_NAME in $LOGS; do
            mkdir -p /ephemeral/var/lib/$LOG_NAME/
            if [[ -d /var/lib/$LOG_NAME/ ]]; then
                rsync -av /var/lib/$LOG_NAME/ /ephemeral/var/lib/$LOG_NAME/
                rm -rf /var/lib/$LOG_NAME
            fi
            ln -sf /ephemeral/var/lib/$LOG_NAME /var/lib/$LOG_NAME
        done

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi
