#!/bin/bash

set -ex

for i in {1..10}; do
    if [[ -f /var/cache/geobase/tzdata.tar.gz ]]; then
        echo "extracting tzdata"

        mkdir -p /var/cache/geobase/tzdata/
        tar -xvzf /var/cache/geobase/tzdata.tar.gz -C /var/cache/geobase/tzdata/

        if [[ "$?" != 0 ]]; then
            continue
        fi

        if [[ -L /usr/share/geobase ]]; then
            rm -f /usr/share/geobase
        fi

        ln -sf /var/cache/geobase/tzdata /usr/share/geobase

        echo "ok"
        break
    else
        echo "No tzdata found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to extract tzdata, cannot start"
    exit 1
fi
