#pragma once

#include <yplatform/context_repository.h>

namespace task_context {

template<typename Context>
struct ContextHolder {
    yplatform::task_context_ptr task;

    ContextHolder()
        : task(boost::make_shared<Context>()) 
    {
        task->begin();
        context_repo.add_context(task);
    }

    ~ContextHolder() {
        removeTaskFromContextRepo();
    }

    const std::string& uniqId() const {
        return task->uniq_id();
    }

    bool cancelled() const {
        return task->is_cancelled();
    }

    void cancel() const {
        task->cancel();
    }

    ContextHolder(const ContextHolder&) = default;
    ContextHolder& operator=(const ContextHolder&) = default;

    ContextHolder& operator=(ContextHolder&&) noexcept = delete;
    ContextHolder(ContextHolder&&) = delete;

protected:
    void removeTaskFromContextRepo() const {
        context_repo.rem_context(task);
    }
};

}
