#include "parser.h"

#include <library/cpp/string_utils/tskv_format/tskv_map.h>

namespace webmail::tskv {

void inplace(std::string_view logLine, ResultWithDeserializeBuffer& result, bool unescape) {
    NTskvFormat::DeserializeMap(logLine, result.parsed, result.buffer, unescape);
}

void notInplace(std::string_view logLine, std::map<std::string, std::string>& result, bool unescape) {
    NTskvFormat::DeserializeMap(logLine, result, unescape);
}

template<class T, class Func>
std::optional<T> parseImpl(std::string_view logLine, Func func) {
    const auto trimTo = logLine.find_first_of("\t");
    if (std::string::npos != trimTo) {
        logLine.remove_prefix(trimTo + 1);
    }

    T result;
    try {
        func(logLine, result, true);
    } catch (const yexception&) {
        try {
            func(logLine, result, false);
        } catch (const yexception&) {
            return std::nullopt;
        }
    }
    return result;
}

std::optional<ResultWithDeserializeBuffer> parseInplace(std::string_view line) {
    return parseImpl<ResultWithDeserializeBuffer>(line, inplace);
}

std::optional<std::map<std::string, std::string>> parse(std::string_view line) {
    return parseImpl<std::map<std::string, std::string>>(line, notInplace);
}

std::optional<TString> join(const std::map<std::string, std::string>& map) {
    TString result;
    try {
        NTskvFormat::SerializeMap(map, result);
    } catch (const yexception&) {
        return std::nullopt;
    }
    return result;
}

}
