#include <string>
#include <map>
#include <optional>
#include <util/generic/string.h>

namespace webmail::tskv {

struct ResultWithDeserializeBuffer {
    std::map<std::string_view, std::string_view> parsed;
    TString buffer;
};

std::optional<ResultWithDeserializeBuffer> parseInplace(std::string_view line);
std::optional<std::map<std::string, std::string>> parse(std::string_view line);
std::optional<TString> join(const std::map<std::string, std::string>& map);

}
