#pragma once

#include <string_view>

#include <mail/mail_errors/unexpected/unexpected.h>
#include <mail/webmail/wait_all/include/internal/impl.h>
#include <mail/webmail/coro_helpers/get_io/include/get_io.h>


namespace wait_all::traits {

struct Boost : public Base {
    using ErrorCode = ::boost::system::error_code;
    using SystemError = ::boost::system::system_error;

    static ErrorCode getUnexpectedErrorCode(const std::string_view = {}) {
        return {static_cast<int>(mail_errors::UnexpectedError::exception), mail_errors::getUnexpectedCategory()};
    }


    static auto&& getCompletionHandler(auto& init) {
        return std::move(init.completion_handler);
    }

    template<typename CompletionToken, typename Result>
    struct AsyncCompletion {
        using type = ::boost::asio::async_completion<CompletionToken, void(ErrorCode, Result)>;
    };

    template<typename CompletionToken>
    struct AsyncCompletion<CompletionToken, void> {
        using type = ::boost::asio::async_completion<CompletionToken, void(ErrorCode)>;
    };

    template<typename CompletionToken, typename Result>
    using AsyncCompletionT = typename AsyncCompletion<CompletionToken, Result>::type;
};

}

namespace boost {

template<typename Result, typename CompletionToken, typename... Fns>
inline auto waitAll(const boost::coroutines::attributes& attr, boost::asio::io_context& io, CompletionToken&& token, Fns&& ...functions) {
    return wait_all::waitAll<Result, wait_all::traits::Boost>(attr, io, std::forward<CompletionToken>(token), std::forward<Fns>(functions)...);
}


template<typename Result, typename... Fns>
inline auto waitAll(boost::asio::yield_context yield, Fns&& ...functions) {
    boost::asio::io_context& io = coro::getIoContext(yield);
    return waitAll<Result>(boost::coroutines::attributes{}, io, std::move(yield), std::forward<Fns>(functions)...);
}

template<typename Result, typename CompletionToken, typename... Fns>
inline auto waitAll(boost::asio::io_context& io, CompletionToken&& token, Fns&& ...functions) {
    return waitAll<Result>(boost::coroutines::attributes{}, io, std::forward<CompletionToken>(token), std::forward<Fns>(functions)...);
}


}
