#pragma once


namespace wait_all::detail {

template<typename CompletionHandler, typename Storage>
struct Guard final : public Storage {

    template<class... Args>
    explicit Guard(CompletionHandler h, Args&&... args) : Storage{std::forward<Args>(args)...}, handler{std::move(h)} {}

    ~Guard() {
        complete();
    }

private:
    CompletionHandler handler;

    void complete() {
        using ErrorCode = std::decay_t<decltype(Storage::getError())>;
        using Result    = std::decay_t<decltype(Storage::getResult())>;

        if constexpr(std::is_invocable_v<CompletionHandler, ErrorCode, Result>) {
            handler(Storage::getError(), Storage::getResult());
        } else {
            handler(Storage::getError());
        }
    }


    Guard(const Guard&) = delete;
    Guard(Guard&&) = delete;

    Guard& operator=(const Guard& other) = delete;
    Guard& operator=(Guard&& other) = delete;
};

}
