#pragma once

#include <boost/asio.hpp>
#include <boost/asio/spawn.hpp>
#include <type_traits>


namespace wait_all::detail {


template<typename F>
struct HandlerInfo {
    inline static constexpr bool need_context = std::is_invocable_v<F, boost::asio::yield_context>;

    using return_type = typename std::conditional_t<need_context,
            std::invoke_result<F, boost::asio::yield_context>,
            std::invoke_result<F>
        >::type;
};


struct Void final {};


template <typename F, typename ...Args, typename Result = std::invoke_result_t<F, Args...>>
requires (not std::is_void_v<Result>)
inline constexpr Result invoke_void(F&& f, Args&& ...args) {
    return std::invoke(std::forward<F>(f), std::forward<Args>(args)...);
}


template <typename F, typename ...Args, typename Result = std::invoke_result_t<F, Args...>>
requires (std::is_void_v<Result>)
inline constexpr Void invoke_void(F&& f, Args&& ...args) {
    std::invoke(std::forward<F>(f), std::forward<Args>(args)...);
    return Void{};
}


template<typename Result, typename... Fns>
inline constexpr void checkConstraints() {
    constexpr bool isAnyVoid = (... ||  std::is_void_v<typename HandlerInfo<Fns>::return_type>);
    static_assert(
        std::is_void_v<Result> ||
        (!std::is_void_v<Result> && !isAnyVoid),
        "Either all functions should return meaningful value, or none of them should."
    );
}

}
