#pragma once

#include <mail/webmail/wait_all/include/internal/storage.h>
#include <mail/webmail/wait_all/include/internal/guard.h>
#include <mail/webmail/wait_all/include/internal/run_one.h>


namespace wait_all {


namespace traits {

struct Base {
    template<typename... Args>
    using StaticContainer = std::tuple<Args...>;

    template<typename... Args>
    using DynamicContainer = std::vector<Args...>;
};

}


namespace detail {


template<typename Traits, typename Guard, std::size_t... Is, typename... Fns>
inline void runAll(std::shared_ptr<Guard>& guard, const boost::coroutines::attributes& attr, boost::asio::io_context& io, std::index_sequence<Is...>, Fns&& ...functions) {
    (runOne<Traits>(guard->template getAccess<Is>(), attr, io, std::forward<Fns>(functions)), ...);
}


template<typename Result, typename Traits, typename CompletionToken>
inline auto getInit(CompletionToken&& token) {
    using AsyncCompletion = typename Traits::template AsyncCompletionT<CompletionToken, Result>;
    return AsyncCompletion{token};
}

}


template<typename Result, typename Traits, typename CompletionToken, typename... Fns>
requires (sizeof...(Fns) > 1)
inline auto waitAll(const boost::coroutines::attributes& attr, boost::asio::io_context& io, CompletionToken&& token, Fns&& ...functions) {
    detail::checkConstraints<Result, Fns...>();

    auto init = detail::getInit<Result, Traits>(std::forward<CompletionToken>(token));

    using Data = typename Traits::template StaticContainer< typename detail::HandlerInfo<Fns>::return_type ... >;
    using CompletionHandler = std::decay_t<decltype(Traits::getCompletionHandler(init))>;
    {
        using Guard = detail::Guard<CompletionHandler, detail::StaticStorage<Result, typename Traits::ErrorCode, Data>>;
        auto guard = std::make_shared<Guard>(Traits::getCompletionHandler(init));

        detail::runAll<Traits>(guard, attr, io, std::index_sequence_for<Fns...>{}, std::forward<Fns>(functions)...);

        guard.reset();
    }
    return init.result.get();
}


template<typename Result, typename Traits, typename CompletionToken,
    typename FuncsContainer, typename FuncT = std::decay_t<typename FuncsContainer::value_type>>
inline auto waitAll(const boost::coroutines::attributes& attr, boost::asio::io_context& io, CompletionToken&& token, FuncsContainer functions) {
    detail::checkConstraints<Result, FuncT>();

    auto init = detail::getInit<Result, Traits>(std::forward<CompletionToken>(token));

    using Data = typename Traits::template DynamicContainer< typename detail::HandlerInfo<FuncT>::return_type >;
    using CompletionHandler = std::decay_t<decltype(Traits::getCompletionHandler(init))>;
    {
        using Guard = detail::Guard<CompletionHandler, detail::DynamicStorage<Result, typename Traits::ErrorCode, Data>>;
        auto guard = std::make_shared<Guard>(Traits::getCompletionHandler(init), functions.size());

        for (size_t i = 0; i < functions.size(); i++) {
            detail::runOne<Traits>(guard->getAccess(i), attr, io, std::move(functions[i]));
        }

        guard.reset();
    }
    return init.result.get();
}

}
