#pragma once

#include <io_result/io_result.h>
#include <io_result/hooks.h>
#include <mail/mail_errors/unexpected/unexpected.h>
#include <mail/webmail/wait_all/include/internal/impl.h>


namespace wait_all::traits {

struct IOResult : public Base {
    using ErrorCode = ::io_result::error_code;
    using SystemError = ::io_result::system_error;

    static ErrorCode getUnexpectedErrorCode(const std::string_view what = {}) {
        return mail_errors::make_error(mail_errors::UnexpectedError::exception, std::string{what});
    }


    static auto&& getCompletionHandler(auto& init) {
        return std::move(init.handler);
    }

    template<typename CompletionToken, typename Result>
    struct AsyncCompletion {
        using signature = std::conditional_t< std::is_void_v<Result>, ::io_result::Hook<>, ::io_result::Hook<Result> >;
        using type = ::io_result::detail::init_async_result<CompletionToken, signature>;
    };

    template<typename CompletionToken, typename Result>
    using AsyncCompletionT = typename AsyncCompletion<CompletionToken, Result>::type;
};

}

namespace io_result {

template<typename Result, typename CompletionToken, typename... Fns>
inline auto waitAll(const boost::coroutines::attributes& attr, boost::asio::io_context& io, CompletionToken&& token, Fns&& ...functions) {
    return wait_all::waitAll<Result, wait_all::traits::IOResult>(attr, io, std::forward<CompletionToken>(token), std::forward<Fns>(functions)...);
}

template<typename Result, typename CompletionToken, typename... Fns>
inline auto waitAll(boost::asio::io_context& io, CompletionToken&& token, Fns&& ...functions) {
    return waitAll<Result>(boost::coroutines::attributes{}, io, std::forward<CompletionToken>(token), std::forward<Fns>(functions)...);
}


}
