#pragma once

#include <yplatform/ptree.h>


namespace ymod_healthcheck {

class Healthcheck {
    bool alive_ = true;
    bool ready_ = true;

    Healthcheck(bool alive, bool ready)
        : alive_(alive)
        , ready_(ready)
    { }

public:

    static Healthcheck alive() {
        return Healthcheck(true, false);
    }

    static Healthcheck ready() {
        return Healthcheck(true, true);
    }

    static Healthcheck dead() {
        return Healthcheck(false, false);
    }

    static Healthcheck fold(Healthcheck check, const yplatform::ptree& stats) {
        if (!stats.get_child_optional("healthcheck")) {
            return check;
        }

        try {
            const bool alive = stats.get<bool>("healthcheck.alive");
            const bool ready = stats.get<bool>("healthcheck.ready");

            if (ready && !alive) {
                return dead();
            } else {
                check.alive_ = check.alive_ && alive;
                check.ready_ = check.ready_ && ready;
            }
        } catch(const std::exception&) {
            return dead();
        }

        return check;
    }

    bool isAlive() const {
        return alive_;
    }

    bool isReady() const {
        return isAlive() && ready_;
    }

    bool isDead() const {
        return !isAlive();
    }

    operator yplatform::ptree () const {
        yplatform::ptree out;
        out.add("healthcheck.alive", alive_);
        out.add("healthcheck.ready", ready_);

        return out;
    }
};

}
