#pragma once

#include <yplatform/ptree.h>


namespace ymod_healthcheck {

using Counter = std::atomic_size_t;

template<class T>
class CounterGuard {
    T& val;

public:
    CounterGuard(T& v)
        : val(v)
    {
        val++;
    }

    ~CounterGuard() {
        val--;
    }

    CounterGuard(const CounterGuard&) = delete;
    CounterGuard& operator=(const CounterGuard&) = delete;

    CounterGuard& operator=(CounterGuard&&) noexcept = default;
    CounterGuard(CounterGuard&&) = default;
};

}
