#include <iostream>

#include <ymod_webserver/server.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/request.h>

#include <yplatform/module_registration.h>
#include <yplatform/loader.h>

#include <mail/webmail/http_api_helpers/include/context.h>
#include <mail/webmail/http_api_helpers/include/handler_helpers.h>

#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <logdog/format/tskv.h>

#include <mail/webmail/ymod_switchbox/include/module.h>

namespace switchbox_example {

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-example-tskv-log"));

auto getModuleLogger() {
    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "example")
    );
}

using ModuleLogger = decltype(getModuleLogger());

struct Worker: public yplatform::module {
public:
    void init(const yplatform::ptree& cfg) {
        reactor_ = http_api::findDependency<yplatform::reactor>(cfg, "dependencies.reactor");
        changer_ = http_api::findDependency<ymod_switchbox::ModuleProvider>(cfg, "dependencies.switchbox");

        LOGDOG_(logger_, notice, logdog::message="switchbox_example::Worker loaded");
    }

    void start() {
        boost::asio::spawn(*reactor_->io(), [=] (boost::asio::yield_context yield) {
            changer_->waitExpectedValue("module_ready", true, io_result::make_yield_context(yield));
            LOGDOG_(logger_, notice, logdog::message="module ready after waiting");
        }, boost::coroutines::attributes(1048576));
    }

private:
    ModuleLogger logger_ = getModuleLogger();
    std::shared_ptr<yplatform::reactor> reactor_;
    std::shared_ptr<ymod_switchbox::ModuleProvider> changer_;
};

}

DEFINE_SERVICE_OBJECT(switchbox_example::Worker)


int main(int argc, char* argv[]) {
    if (argc != 2) {
        std::cout << "usage " << argv[0] << " <config>\n";
        return 1;
    }

    return yplatform_start(argv[1]);
}
