#pragma once

#include <io_result/io_result.h>
#include <io_result/hooks.h>

namespace ymod_switchbox {

using OnValue = io_result::Hook<bool>;

struct ModuleProvider {
    virtual ~ModuleProvider() = default;

    template<class Handler>
    auto waitExpectedValue(const std::string& name, bool expectedValue, Handler handler) {
        io_result::detail::init_async_result<Handler, OnValue> init(handler);
        asyncWaitExpectedValue(name, expectedValue, init.handler);
        return init.result.get();
    }

    virtual bool getValue(const std::string& name) = 0;

protected:
    virtual void asyncWaitExpectedValue(const std::string& name, bool expectedValue, OnValue hook) = 0;
};
using ModuleProviderPtr = std::shared_ptr<ModuleProvider>;

};
