#pragma once

#include <mail/webmail/http_api_helpers/include/response.h>

namespace ymod_switchbox {
    
struct StatusResult {
    std::map<std::string, bool> values;
};

class Response: public http_api::Response {
protected:
    void logSuccessResponse(const std::string&) const override { }
    void logErrorResponse(const std::string&) const override { }
    bool errorCodeToResponseCode(const mail_errors::error_code&, ymod_webserver::codes::code&) const override {
        return false;
    }

public:
    Response(ymod_webserver::response_ptr s)
        : http_api::Response(std::move(s))
    { }

    using http_api::Response::with;

    void with(StatusResult&& resp) const {
        defaultJsonResponse(std::move(resp));
    };
};

}

BOOST_FUSION_ADAPT_STRUCT(ymod_switchbox::StatusResult, values)
