#!/bin/bash

set -ex

source functions.sh

while getopts ":v:t:o:w:q:p:f:e:b:z:" opt; do
    case $opt in
        v)
            TAG="$OPTARG" >&2
            ;;
        t)
            TOKEN="$OPTARG" >&2
            ;;
        o)
            OUTPUT="$OPTARG" >&2
            ;;
        w)
            WMIQA="$OPTARG" >&2
            ;;
        q)
            JQ="$OPTARG" >&2
            ;;
        p)
            PROJECTS=`echo "$OPTARG" | sed -e 's|message_body|mbody|'` >&2
            ;;
        f)
            PREFIX="$OPTARG" >&2
            ;;
        e)
            PREFIX_ENV="$OPTARG" >&2
            ;;
        b)
            BASE_DIR="$OPTARG" >&2
            ;;
        z)
            ENV_VARS="$OPTARG" >&2
            ;;
        \?)
            echo "invalid option: -$OPTARG" >&2
            ;;
    esac
done

[[ -z "$BASE_DIR" ]] && BASE_DIR="environment"

generate_version "$TAG" "$PROJECTS" "$PREFIX" "$PREFIX_ENV"

WMIQA_CMD="$WMIQA --env_name=\"$ENV_NAME\" --out=data.json --base_dir=\"$BASE_DIR\" --env_vars=\"$ENV_VARS\""

for proj in $PROJECTS; do
    copy_project_from_production "$proj" "$TOKEN"
done

eval $WMIQA_CMD

create_env_and_wait "$ENV_NAME" "$ENV_VERSION" "$TOKEN" "$OUTPUT"
