import os
import sys
import json
from multiprocessing import Pool
from subprocess import Popen, PIPE

SHELL = '/bin/bash'
RESOURCE_TYPE = 'WEBMAIL_DEBUG_SYMBOLS'


def create_process(cmd: str, retry=0, dest=None, comm=False):
    print('run command:', cmd)

    proc = Popen([cmd], shell=True, executable=SHELL, stdout=dest)

    outs, errs = proc.communicate()

    while proc.returncode != 0 and retry > 0:
        outs, errs = proc.communicate()
        retry -= 1

    exit_code = proc.returncode

    if exit_code != 0:
        raise RuntimeError('execute command `{cmd}` was failed\nSent there errors: {errs}'.format(cmd=cmd, errs=errs))

    if comm:
        if not outs:
            raise RuntimeError("ya upload wasn't return url to resource")

        return outs.decode('utf-8')


def fn(arg):
    project_path, bin_path = [a.split('=')[1] for a in arg.split(';')]  # project_path=mail/doberman;bin_path=src/doberman 

    path_debug = os.path.join(project_path, bin_path) + '.debug'
    debug_symbols_name = path_debug.split('/')[-1]

    package_version = os.getenv('PACKAGE_VERSION')
    if not package_version:
        raise RuntimeError('variable `PACKAGE_VERSION` is empty!')

    cmd_upload_sandbox = '''./ya upload {path_debug} \
    --ttl=182 --type={RESOURCE_TYPE} --owner=MAIL -A version={package_version} -A name={resource_name} \
    --json-output'''.format(
        path_debug=path_debug,
        RESOURCE_TYPE=RESOURCE_TYPE,
        package_version=package_version,
        resource_name=debug_symbols_name,
    )
    outs = create_process(cmd_upload_sandbox, retry=2, dest=PIPE, comm=True)

    resource_url = json.loads(outs).get('download_link')
    with open('{project_path}/package/debug_symbols_url'.format(project_path=project_path), 'a') as file:
        file.write(resource_url)


if __name__ == '__main__':
    args = sys.argv[1:]
    if not args:
        raise ValueError('1st argument must be name of project')

    pool = Pool(len(args))
    pool.map(fn, args)

    pool.close()
    pool.join()
