#!/bin/bash

set -ex


function image_hash {
    curl -s "https://dockinfo.yandex-team.ru/api/docker/resolve?registryUrl=$1&tag=$2" | $JQ -r '.hash'
}


while getopts ":v:t:c:q:p:l:" opt; do
    case $opt in
        v)
            TAG="$OPTARG" >&2
            ;;
        t)
            TOKEN="$OPTARG" >&2
            ;;
        c)
            COMMENT="$OPTARG" >&2
            ;;
        q)
            JQ="$OPTARG" >&2
            ;;
        p)
            PROJECT="$OPTARG" >&2
            ;;
        l)
            LOGROTATION="$OPTARG" >&2
            ;;
        \?)
            echo "invalid option: -$OPTARG" >&2
            ;;
    esac
done


REGISTRY='registry.yandex.net/mail'
HOST="https://platform.yandex-team.ru"
AUTH="authorization: OAuth $TOKEN"


ENV_NAME="mail.$PROJECT.load"
IMG="$REGISTRY/$PROJECT/$PROJECT"


./make_load_env -o data.json -i "$IMG:$TAG" --hash $(image_hash $IMG $TAG) -c "$COMMENT" -p "$PROJECT"


curl -v --fail -H "$AUTH" "$HOST/api/v1/environment/upload/return-header" --data-binary "@data.json" -H "content-type: application/json"


while true; do
    status="$(curl -s -H "$AUTH" "$HOST/api/v1/environment/stable/$ENV_NAME" | $JQ -r '.status')"

    case "$status" in
        DEPLOYED )
            break;
            ;;
        * )
            echo "Environment's status is \'$status\'"
            ;;
    esac
    sleep 10
done;

if $LOGROTATION; then
    host=$(curl -s -H "$AUTH" "$HOST/api/v1/environment/stable/$ENV_NAME" | $JQ -r ".components.$PROJECT.runningInstances[0].host")
    ssh $host -C '/usr/sbin/logrotate -f /etc/logrotate.conf'
fi
