import jinja2
import json
from argparse import ArgumentParser


def main():
    def render(text, salt):
        return jinja2.Environment(undefined=jinja2.StrictUndefined).from_string(text).render(**salt)

    parser = ArgumentParser()

    parser.add_argument(
        '-i', '--image',
        help='image'
    )

    parser.add_argument(
        '-s', '--hash',
        help='image hash'
    )

    parser.add_argument(
        '-c', '--comment',
        default='',
        help='comment for deploy'
    )

    parser.add_argument(
        '-o', '--output'
    )

    parser.add_argument(
        '-p', '--project',
        help='project name'
    )

    args = parser.parse_args()

    with open(args.project + '/env_template.json') as f:
        full = f.read()
        text = render(full, {
            'comment': args.comment,
            'image': args.image,
            'hash': args.hash
        })

    dump_for_upload = json.dumps(json.loads(text), indent=4, sort_keys=True)

    with open(args.output, 'w') as f:
        f.write(dump_for_upload)


if __name__ == '__main__':
    main()

