# -*- coding: utf-8 -*-
import jinja2
import json
from os.path import join
from argparse import ArgumentParser


def main():
    def render(text, salt):
        return jinja2.Environment(undefined=jinja2.StrictUndefined).from_string(unicode(text)).render(**salt)

    parser = ArgumentParser()

    parser.add_argument(
        'service',
        nargs='+',
        help='services to deploy, format: "service name image hash"'
    )

    parser.add_argument(
        '--env_name',
        required=True,
        help='name of environment'
    )

    parser.add_argument(
        '--out',
        required=True,
        help='version of environment'
    )

    parser.add_argument(
        '--base_dir',
        required=False,
        default='environment',
        help='dir with templates of qloud-environment'
    )

    parser.add_argument(
        '--env_vars',
        required=False,
        help='user environment variables for environment'
    )

    args = parser.parse_args()

    config = {}
    config['services'] = []
    config['env_name'] = args.env_name

    base_dir = args.base_dir

    for line in args.service:
        service, name, image, sha = [l for l in line.split(' ') if l]
        name = name.replace('_', '-')

        with open(join(base_dir, service+'.json')) as f:
            full = f.read()
            text = render(full, {
                'name': name,
                'image': image,
                'hash': sha
            })

        config['services'].append(str(text))

    env_vars = '' if args.env_vars is None else args.env_vars
    config.update({'env_vars': env_vars})
    with open(join(base_dir, 'environment.json')) as f:
        full = f.read()
        environment = str(render(full, config))

    environment = json.dumps(json.loads(environment), indent=4, sort_keys=True)

    print(environment)

    with open(args.out, 'w') as f:
        f.write(environment)
