#!/bin/bash

set -ex

source functions.sh

while getopts ":v:t:o:w:q:p:" opt; do
    case $opt in
        v)
            TAG="$OPTARG" >&2
            ;;
        t)
            TOKEN="$OPTARG" >&2
            ;;
        o)
            OUTPUT="$OPTARG" >&2
            ;;
        w)
            WMIQA="$OPTARG" >&2
            ;;
        q)
            JQ="$OPTARG" >&2
            ;;
        p)
            PROJECTS=`echo "$OPTARG" | sed -e 's|message_body|mbody|'` >&2
            ;;
        \?)
            echo "invalid option: -$OPTARG" >&2
            ;;
    esac
done

generate_version "$TAG" "$PROJECTS" ""

WMIQA_CMD="$WMIQA --env_name=\"$ENV_NAME\" --out=data.json"

for proj in $PROJECTS; do
    add_proj "$proj" "$TAG"
done

eval $WMIQA_CMD

create_env_and_wait "$ENV_NAME" "$ENV_VERSION" "$TOKEN" "$OUTPUT"
