#!/usr/bin/env bash

set -ex

host_is_not_balancer() {
    if [[ "$1" == *".mail.yandex.net" ]]; then
        return 1
    else
        return 0
    fi
}

HOST_SENDBERNAR=`cat $WORKSPACE/hosts.props | fgrep 'HOST_SENDBERNAR' | cut -d= -f2`
HOST_HOUND=`cat $WORKSPACE/hosts.props | fgrep 'HOST_HOUND' | cut -d= -f2`
HOST_RETRIEVER=`cat $WORKSPACE/hosts.props | fgrep 'HOST_RETRIEVER' | cut -d= -f2`

if host_is_not_balancer "$HOST_HOUND" && host_is_not_balancer "$HOST_RETRIEVER"; then
    cd ./postinst/retriever/
    . ./postinst.sh
    cd ../../
fi

if host_is_not_balancer "$HOST_SENDBERNAR"; then
    cd ./postinst/sendbernar/
    . ./postinst.sh
    cd ../../
fi
