#!/bin/bash

##
## packages from dev image
##

apt-get update && apt-get -y install \
apt-transport-https \
ca-certificates \
gnupg-agent \
software-properties-common \
build-essential \
cmake \
libc6-dbg \
gdb \
subversion \
git \
cvs \
ntp \
screen \
tmux \
man \
ack-grep \
apt-file \
autoconf \
cgdb \
clang \
cmake \
g++-4.7 \
g++-4.8 \
gcc-4.7 \
gcc-4.8 \
realpath \
git-svn \
glibc-doc \
global \
mercurial \
nano \
perl-doc \
pigz \
pychecker \
python-bsddb3 \
python-dev \
python-lxml \
python-mysqldb \
python-numpy \
python-pip \
python-pysqlite2 \
python-scipy \
python-tk \
python-virtualenv \
valgrind \
watchdog \
devscripts \
patch \
zip \
llvm \
lldpd \
cifs-utils \
unzip \
vim \
time \
jq \
telnet \
yandex-internal-root-ca \
yandex-search-coredump-watcher

##
##  repos
##

cat << EoF > /etc/apt/sources.list.d/mail-trusty-stable.list
deb http://dist.yandex.ru/mail-trusty stable/all/
deb http://dist.yandex.ru/mail-trusty stable/\$(ARCH)/
EoF

curl https://apt.llvm.org/llvm-snapshot.gpg.key | sudo apt-key add -
cat << EoF > /etc/apt/sources.list.d/llvm.list
deb http://apt.llvm.org/trusty/ llvm-toolchain-trusty-5.0 main
deb-src http://apt.llvm.org/trusty/ llvm-toolchain-trusty-5.0 main
EoF

curl https://www.postgresql.org/media/keys/ACCC4CF8.asc | sudo apt-key add -
cat << EoF > /etc/apt/sources.list.d/postgres.list
deb http://apt.postgresql.org/pub/repos/apt/ trusty-pgdg main
deb http://dist.yandex.ru/yandex-postgresql stable/all/
deb http://dist.yandex.ru/yandex-postgresql stable/\$(ARCH)/
EoF

##
## debian
##

apt-get update && apt-get -y install devscripts debhelper dupload fakeroot

cat /etc/dupload.conf | head -n -7 > /etc/dupload.conf.new

cat <<EoF >> /etc/dupload.conf.new
#
# Yandex repositories
#

\$cfg{'common'} = {
    fqdn => "common.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/common/mini-dinstall/incoming/",
    dinstall_runs => 0,
};

\$cfg{'yandex-trusty'} = {
    fqdn => "yandex-trusty.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/yandex-trusty/mini-dinstall/incoming/",
    dinstall_runs => 0,
};

\$cfg{'verstka'} = {
    fqdn => "verstka.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/verstka/mini-dinstall/incoming/",
    dinstall_runs => 0,
};


#
# Mail-specific repos
#
\$cfg{'mail-trusty'} = {
    fqdn => "mail-trusty.dupload.dist.yandex.ru",
    method => "scpb",
    incoming => "/repo/mail-trusty/mini-dinstall/incoming/",
    dinstall_runs => 0,
};

\$cfg{'secmail'} = {
    fqdn => "secdist.yandex.net",
    method => "scpb",
    incoming => "/repo/debian/secmail/mini-dinstall/incoming/",
    dinstall_runs => 0,
};

# Don't remove the following line.  Perl needs it.
1;

## Local Variables: ##
## mode:perl ##
## End: ##
EoF

mv /etc/dupload.conf.new /etc/dupload.conf

##
## python
##

apt-get -y install python3.5 python3.5-dev python3-lxml libpython3.5 libidn11
wget https://bootstrap.pypa.io/get-pip.py -O /tmp/get-pip.py
python3.5 /tmp/get-pip.py
rm /tmp/get-pip.py

cat << EoF > /opt/pip3-requirements.txt
chardet==2.2.1
colorama==0.2.5
html5lib==0.999
httplib2==0.8
lxml==3.3.3
PyYAML==3.10
requests==2.2.1
six==1.5.2
urllib3==1.7.1
EoF

pip3 install -r /opt/pip3-requirements.txt

update-alternatives --install /usr/bin/python3 python3 /usr/bin/python3.5 1

##
## other
##

apt-get -y install clang-5.0 clang++-5.0 ccache
apt-get -y install yandex-jdk8

ln -sf /bin/bash /bin/sh

##
## docker
##

curl https://download.docker.com/linux/ubuntu/gpg | sudo apt-key add -

cat << EoF > /etc/apt/sources.list.d/docker.list
deb [arch=amd64] https://download.docker.com/linux/ubuntu trusty stable
EoF

# dirty hacks for docker
echo -e '#!/bin/bash\nexit 101' > /usr/sbin/policy-rc.d
chmod +x /usr/sbin/policy-rc.d

apt-get update && apt-get -y install docker-ce

rm /usr/sbin/policy-rc.d

mkdir /etc/iptables
cat << EoF > /etc/iptables/rules.v6
*nat
:PREROUTING ACCEPT [232:29413]
:INPUT ACCEPT [232:29413]
:OUTPUT ACCEPT [60:77419]
:POSTROUTING ACCEPT [0:0]
-A POSTROUTING ! -o docker0 -j MASQUERADE
COMMIT
EoF

cat << EoF > /etc/rc.local
#!/bin/sh -e

ip6tables-restore < /etc/iptables/rules.v6

exit 0
EoF

cat << EoF >> /etc/default/docker
export DOCKER_OPTS="\$DOCKER_OPTS --ipv6 --fixed-cidr-v6=2001:db8:1::/64 --dns 2a02:6b8:0:3400::1023"
export DOCKER_OPTS="\$DOCKER_OPTS --storage-driver=overlay"
export DOCKER_OPTS="\$DOCKER_OPTS -H unix:///var/run/docker.sock"
export DOCKER_OPTS="\$DOCKER_OPTS -H tcp://127.0.0.1:4243"
EoF

cat << EoF > /etc/cron.d/docker-cleanup
SHELL=/bin/sh
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin

00 04 * * * root /etc/cron.yandex/docker-cleanup.sh > /dev/null 2>&1

EoF

chmod 644 /etc/cron.d/docker-cleanup

mkdir /etc/cron.yandex
cat << EoF > /etc/cron.yandex/docker-cleanup.sh
#!/bin/bash

echo "[INFO] Started"

docker container prune -f
docker image prune -f

echo "[INFO] Done"

EoF

chmod +x /etc/cron.yandex/docker-cleanup.sh

# https://sandbox.yandex-team.ru/resource/1263224696/view
curl "https://proxy.sandbox.yandex-team.ru/1263224696" -o /usr/local/bin/docker-compose
chmod +x /usr/local/bin/docker-compose

cat << EoF > /etc/ntp.conf
# /etc/ntp.conf, configuration for ntpd; see ntp.conf(5) for help

driftfile /var/lib/ntp/ntp.drift

statistics loopstats peerstats clockstats
filegen loopstats file loopstats type day enable
filegen peerstats file peerstats type day enable
filegen clockstats file clockstats type day enable

restrict -4 default kod notrap nomodify nopeer noquery
restrict -6 default kod notrap nomodify nopeer noquery

restrict 127.0.0.1
restrict ::1

server ntp1.yandex.net iburst burst prefer
server ntp2.yandex.net iburst burst
server ntp3.yandex.net iburst burst
server ntp4.yandex.net iburst burst

EoF

