import {
    Address,
    Attachment,
    Body,
    Color,
    FileType,
    Folder,
    FolderType,
    Label,
    Mailbox,
    Message,
    MimeType
} from "./model";
import {colorImage, randomEmail, randomPlainContent, randomSubject} from "./utils";

export class SimpleMailbox extends Mailbox {

    private label: Label = null;

    constructor(seed: string = null) {
        super(true, seed);
    }

    protected userFolders(): Folder[] {
        return [
            super.createUserFolder("Папка 1", this.root),
            super.createUserFolder("Папка 2", this.root),
            super.createUserFolder("Папка 3", this.root)
        ]
    }

    protected labels(): Label[] {
        this.label = super.createUserLabel("Метка 1", Color.RED);
        return [
            this.label,
            super.createUserLabel("Метка 2", Color.GREEN),
            super.createUserLabel("Метка 3", Color.BLUE)
        ]
    }

    protected folderMessages(folder: Folder): Message[] {
        if (folder.type == FolderType.INBOX) {
            let attachment = new Attachment({
                hid: "1.3",
                diplayName: "Тест",
                fileType: FileType.IMAGE,
                size: 10,
                mime: MimeType.PNG,
                url: colorImage(100, 100, "FF00FF", "attach.png")
            });
            return [
                new Message({
                    folder: folder,
                    subject: randomSubject(super.random()),
                    from: new Address(randomEmail(super.random())),
                    to: [new Address(randomEmail(super.random()))],
                    labels: [this.label],
                    bodies: [new Body("1.2", randomPlainContent(super.random()), MimeType.PLAIN)]
                }),
                new Message({
                    folder: folder,
                    subject: randomSubject(super.random()),
                    from: new Address(randomEmail(super.random())),
                    to: [new Address(randomEmail(super.random()))],
                    bodies: [new Body("1.2", randomPlainContent(super.random()), MimeType.PLAIN)],
                    attachments: [attachment]
                })
            ]
        }
        return [];
    }

}
