import * as random from "random";
import * as uuid from "uuid/v4";
import {Color} from "./model";

export function generateID(): string {
    const hrt = process.hrtime();
    return String(hrt[0] * 1000000 + hrt[1]);
}

export function timestamp(): number {
    return Date.now();
}

export function utcTimestamp(): number {
    return timestamp();
}

export function randomEmail(rng = null): string {
    const rnd = rng || random;
    const contents = ["example@example.com", "example@example.ru"];
    return contents[rnd.int(0, contents.length - 1)];
}

export function randomSubject(rng = null): string {
    const rnd = rng || random;
    const contents = ["English subject", "Русская тема"];
    return contents[rnd.int(0, contents.length - 1)];
}

export function randomPlainContent(rng = null): string {
    const rnd = rng || random;
    const contents = ["English content", "Русский контент"];
    return contents[rnd.int(0, contents.length - 1)];
}

export function colorImage(width: number, height: number, color: string, filename: string) {
    return `/c/image/${width}/${height}/${color}/${filename}`
}

export enum NameSize {
    SHORT,
    NORMAL,
    LONG
}

export function uniqueName(size: NameSize = NameSize.NORMAL): string {
    // @ts-ignore
    if (typeof uniqueName.counter == 'undefined' ) {
        // @ts-ignore
        uniqueName.counter = 0;
    }
    switch (size) {
        case NameSize.SHORT: {
            // @ts-ignore
            uniqueName.counter++;
            // @ts-ignore
            return "" + uniqueName.counter;
        }
        case NameSize.NORMAL: {
            return uuid();
        }
        default: {
            return uuid();
        }
    }

}

export function randomColor(rng = null) {
    const rnd = rng || random;
    let colors = [Color.BLUE, Color.BLUE, Color.GREEN];
    return colors[rnd.int(0, colors.length - 1)];
}
