import {Toxy} from "../core/configuration";
import {Poisons} from "../poisons/poison";
import {Rules} from "../rules/rules";
import {Utils} from "../utils/utils";

export class CommonConfigurations {
    static metro(toxy: Toxy) {
        CommonConfigurations.infinite(toxy).withRule(Rules.timeThreshold(20_000, 60_000));
    }

    static random500(toxy: Toxy, percent_str: string) {
        let percent = Utils.parseIntUnsafe(percent_str);
        toxy.all('/*')
            .poison(Poisons.responseWithDelay(1000))
            .poison(Poisons.responseError500())
            .withRule(Rules.probability(percent));
    }

    static periodicallyInfiniteResponse(toxy: Toxy) {
        toxy.all('/*')
            .poison(Poisons.infinitelyLongResponse())
            .withRule(Rules.probability(20));
    }

    static readonly(toxy: Toxy) {
        toxy.all('/*')
            .poison(Poisons.responseServiceUnavailable())
            .withRule(Rules.method(['POST', 'PUT', 'DELETE']))
    }

    static infinite(toxy: Toxy): Toxy {
        return toxy.all('/*').poison(Poisons.bandWidth(1, 4000));
    }

    static edge(toxy: Toxy): Toxy {
        return toxy.all('/*')
            .poison(Poisons.latency(null, 10, 50))
            .poison(Poisons.bandWidth(1000, 100))
    }

    static rps(toxy: Toxy, rps_str: string) {
        let rps = Utils.parseFloatUnsafe(rps_str);
        toxy.all('/*').poison(Poisons.rateLimit(rps));
    }

    static response500(toxy: Toxy, path_str: string) {
        let path = path_str.replace(/@/gi, '/');
        toxy.all('/' + path).poison(Poisons.responseError500());
    }

    static empty(toxy: Toxy) {
    }
}
