import {Toxy} from "../core/configuration";
import {MobileAPI} from "../poisons/mail/handlers";
import {Poison, Poisons} from "../poisons/poison";
import {TimeBucketConfiguration} from "../poisons/mail/buckets/buckets";
import {PatchResponsePoisonProvider, ResponsePatcher} from "../poisons/patch";
import {SimpleMailbox} from "../client/simple";
import {emulate} from "../poisons/mail/emulator";
import {ExperimentConfiguration} from "../poisons/mail/experiment";
import {LargeMailbox} from "../client/large";
import {UploadResponsePatcher} from "../poisons/mail/attach/upload";
import {StorePatcher} from "../poisons/mail/attach/store";
import {WizardsResponsePatcher} from "../poisons/mail/wizards/wizards-response-patcher";

export class MailPublicConfigurations {
    static MOBILEMAIL_12646(toxy: Toxy) {
        toxy.all(MobileAPI.SETTINGS).poison(Poisons.responseError500());
    }

    static MOBILEMAIL_12647(toxy: Toxy) {
        toxy.all(MobileAPI.SETTINGS).poison(Poisons.responseError200());
    }

    static MOBILEMAIL_12648(toxy: Toxy) {
        toxy.all(MobileAPI.XLIST).poison(Poisons.abort());
    }

    static MOBILEMAIL_12650(toxy: Toxy) {
        toxy.post(MobileAPI.SETTINGS).poison(Poisons.responseJson(200, {
            "status": {"status": 1},
            "account_information": {}
        }));
    }

    static MOBILEMAIL_12651(toxy: Toxy) {
        toxy.all(MobileAPI.XLIST).poison(Poisons.responseError200());
    }

    static MOBILEMAIL_12652(toxy: Toxy) {
        toxy.post(MobileAPI.AVA2).poison(Poisons.infinitelyLongResponse());
    }

    static MOBILEMAIL_12653(toxy: Toxy) {
        toxy.all(MobileAPI.XLIST).poison(Poisons.abort());
    }

    static MOBILEMAIL_12656(toxy: Toxy) {
        toxy.post(MobileAPI.SEARCH).poison(Poisons.abort());
    }

    static MOBILEMAIL_12807(toxy: Toxy) {
        toxy.post(MobileAPI.MESSAGES).poison(Poisons.infinitelyLongResponse());
    }

    static MOBILEMAIL_12867(toxy: Toxy) {
        toxy.post(MobileAPI.GET_TAB_COUNTERS).poison(Poisons.responseError500());
    }

    static buckets(toxy: Toxy) {
        new TimeBucketConfiguration().configure(toxy);
    }

    static simple_mailbox(toxy: Toxy) {
        emulate(new SimpleMailbox(), toxy);
    }

    static no_experiments(toxy: Toxy) {
        new ExperimentConfiguration("empty.json").configure(toxy);
    }

    static image(toxy: Toxy, width: string, height: string, color: string, file: string, cb) {
        let cb2 = (poison: Poison, error) => {
            toxy.all("/*").poison(poison);
            cb(error);
        };
        Poisons.responseByImage(file, parseInt(width), parseInt(height), color, cb2);
    }

    static large_mailbox(toxy: Toxy) {
        emulate(new LargeMailbox(), toxy);
    }

    static attach_md5(toxy: Toxy) {
        let uploadPoison = new PatchResponsePoisonProvider(new UploadResponsePatcher()).create();
        toxy.all(MobileAPI.UPLOAD).poison(uploadPoison);
        let storePoison = new PatchResponsePoisonProvider(new StorePatcher()).create();
        toxy.all(MobileAPI.STORE).poison(storePoison);
    }

    static append_calendar_wizards_data(toxy: Toxy) {
        let uploadPoison = new PatchResponsePoisonProvider(new WizardsResponsePatcher("calendar", "updated")).create();
        toxy.all(MobileAPI.MESSAGES).poison(uploadPoison);
    }

}
