import {MailPublicConfigurations} from "./mail";
import {Toxy, ToxyConfiguration} from "../core/configuration";
import {CommonConfigurations} from "./common";
import {LoggingPoisonProvider} from "../poisons/logger";
import {DisableGzipPoisonProvider} from "../poisons/gzip";
import {SandboxConfiguration} from "./sandbox";

export class PublicConfigurationsProvider {
    // Replace ACTIVE_CONFIGURATION with ticket. For example,
    // static ACTIVE_CONFIGURATION = PublicConfigurations.MOBILEMAIL_12648;
    static ACTIVE_CONFIGURATION = undefined;

    static ALL_NAMESPACES = [CommonConfigurations, MailPublicConfigurations];

    static demandByName(name: string): (toxy: Toxy) => void {
        for (let namespace of this.ALL_NAMESPACES) {
            if (namespace[name]) {
                return namespace[name];
            }
        }
        throw Error(`No configuration with name ${name}`);
    }

    static allConfigurations(): string[] {
        let result: string[] = [];
        for (let namespace of this.ALL_NAMESPACES) {
            for (let method in namespace) {
                result.push(method);
            }
        }
        return result;
    }

    static activeConfiguration(): ToxyConfiguration {
        return new class implements ToxyConfiguration {
            configure(toxy: Toxy): void {
                if (PublicConfigurationsProvider.ACTIVE_CONFIGURATION) {
                    PublicConfigurationsProvider.ACTIVE_CONFIGURATION(toxy)
                }
            }
        }
    }
}

class CommonConfiguration implements ToxyConfiguration {
    configure(toxy: Toxy): void {
        toxy.poison(new LoggingPoisonProvider().create())
            .poison(new DisableGzipPoisonProvider().create());
    }
}

export let MANDATORY_CONFIGURATIONS: ToxyConfiguration[] = [
    new CommonConfiguration(),
    // new TimeBucketConfiguration(),
    // new FixedResponseConfiguration(MobileAPI.MESSAGES, "poisons/mail/error/auth.json"),
    PublicConfigurationsProvider.activeConfiguration(),
    new SandboxConfiguration()
];
