import {ToxyConfiguration} from "../core/configuration";
import {Toxy} from "../core/configuration";
import {Poisons} from "../poisons/poison";
import {MobileAPI} from "../poisons/mail/handlers";
import {Rules} from "../rules/rules";

export class SandboxConfiguration implements ToxyConfiguration {
    configure(toxy: Toxy) {
        // вы можете использовать предустановленные Poisons (см. poison.ts)
        // примеры ниже показывают, как это делать
        // просто скопипастите сюда код из любого примера и перезапустите проксю - соответствующая конфигурация начнет работать

    }

    private abortAllHandlersExample(toxy: Toxy) {
        toxy.all('/*').poison(Poisons.abort());
    }

    private emulateVerySlowInternetExample(toxy: Toxy) {
        toxy.all('/*').poison(Poisons.bandWidth(1000));
    }

    private emulateVerySlowSearchExample(toxy: Toxy) {
        toxy.post(MobileAPI.SEARCH).poison(Poisons.responseWithDelay(50000));
    }

    private reject500ForXlist(toxy: Toxy) {
        toxy.post(MobileAPI.SEARCH_SUGGEST).poison(Poisons.responseError200())
    }

    private randomJitterAndBandWidth(toxy: Toxy) {
        toxy.all(MobileAPI.MESSAGES)
            .poison(Poisons.latency(null, 100, 1000))
            .poison(Poisons.bandWidth(1000))
            .withRule(Rules.probability(50));
    }
}
