import {Poison, PoisonProvider} from "./poison";
import {IncomingMessage, ServerResponse} from "http";

export class DisableGzipPoisonProvider implements PoisonProvider {
    create(): Poison {
        return (req: IncomingMessage, res: ServerResponse, next: () => void) => {
            delete req.headers['accept-encoding'];
            next();
        };
    }
}
