import {IncomingMessage, ServerResponse} from "http";
import {Poison, PoisonProvider} from "./poison";
import * as getRawBody from "raw-body";

export class LoggingPoisonProvider implements PoisonProvider {
    static PRIVATE_HEADERS = ['cookie', 'authorization'];

    create(): Poison {
        return (req: IncomingMessage, res: ServerResponse, next: () => void) => {
            getRawBody(req, (err: getRawBody.RawBodyError, body: Buffer) => {
                if (err) {
                    console.error('Cant read request body', err);
                    return
                }
                console.log(LoggingPoisonProvider.curl(req, body.toString()));
                // Expose cached body in the request to forward it
                // @ts-ignore
                req.body = body;
            });
            next();
        };
    }

    static curl(req: IncomingMessage, body: string): string {
        var headers = '';
        Object.keys(req.headers).forEach((name: string) => {
            let value = LoggingPoisonProvider.isPrivateHeader(name) ? '***' : req.headers[name];
            headers += `-H '${name}: ${value}' `;
        });
        let bodyString = body ? `-d '${body}'` : '';
        return `curl -X ${req.method} '${req.url}' ${bodyString} ${headers}`
    }

    static isPrivateHeader(name: string): boolean {
        return this.PRIVATE_HEADERS.filter(privateHeader => privateHeader == name.toLowerCase()).length > 0
    }
}
