import {ResponsePatcher, Request} from "../../patch";
import * as syncRequest from 'sync-request';
import {Utils} from "../../../utils/utils";

export class StorePatcher implements ResponsePatcher {
    patch(jsonBody: any, request?: Request): any {
        let mid = jsonBody.mid;
        for (let attachment of jsonBody.attachments.attachment) {
            let hid = attachment.hid;
            let response = syncRequest.default('POST', 'https://mail.yandex.ru/api/mobile/v1/attach', {
                headers: {
                    'Authorization': request.headers.authorization,
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `mid=${mid}&hid=${hid}`
            });
            // @ts-ignore
            let url = JSON.parse(response.body).url;
            let file = syncRequest.default('GET', url).body;
            attachment['hash'] = Utils.md5(file);
        }
        return jsonBody;
    }
}
