import * as fs from 'fs';
import {MobileAPI} from "./handlers";
import {Toxy, ToxyConfiguration} from "../../core/configuration";
import {Poisons} from "../poison";

export class ExperimentConfiguration implements ToxyConfiguration {
    private fileName: string;

    constructor(fileName: string) {
        this.fileName = fileName;
    }

    configure(toxy: Toxy): void {
        toxy.all(MobileAPI.UAZ).poison(Poisons.responseJson(200, {
            "status": {
                "status": 1
            },
            "uaz": [
                JSON.parse(fs.readFileSync(`resources/mail/experiment/${this.fileName}`, 'utf8'))
            ]
        }))
    }
}
