import * as url from "url";

export enum MobileAPI {
    AVA2 = '/api/mobile/v1/ava2',
    MESSAGES = '/api/mobile/v1/messages',
    SEARCH = '/api/mobile/v1/search',
    SETTINGS = '/api/mobile/v1/settings',
    UAZ = '/api/mobile/v1/uaz',
    XLIST = '/api/mobile/v1/xlist',
    MESSAGE_BODY = '/api/mobile/v1/message_body',
    ATTACH = "/api/mobile/v1/attach",
    UPLOAD = "/api/mobile/v1/upload",
    STORE = "/api/mobile/v1/store",

    GET_TAB_COUNTERS = '/api/mobile/v2/get_tab_counters',
    DISK_OPERATIONS_STATUS = '/api/mobile/v2/disk_operations_status',
    DISK_SAVE_ALL = '/api/mobile/v2/disk_save_all',
    SEARCH_SUGGEST = '/api/mobile/v2/search_suggest',
    APNS_REPEAT = '/api/mobile/v2/apns_queue_repeat'
}

export function urlToMobileAPIHandler(u: string): string | null {
    for (let name of Object.keys(MobileAPI)) {
        let value = MobileAPI[name];
        if (url.parse(u).pathname.endsWith(value)) {
            return value;
        }
    }
    return null;
}
